<?php

namespace App\Http\Controllers\Api\Hacienda;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use App\Http\Controllers\ApiController;
use App\Services\TipoCambioService;

class TipoCambioController extends ApiController
{
    public function __construct(
        protected TipoCambioService $service,
    ) {}

    public function __invoke(Request $request): JsonResponse
    {
        $moneda = strtoupper(trim((string) $request->query('moneda', 'CRC')));

        // Hacienda primero para USD/EUR, fallback BCCR solo USD
        $providers = ['hacienda', 'bccr'];

        return response()->json($this->service->obtenerCambioActual($providers, $moneda));
    }
}
