<?php

namespace App\HttpClients\DTOs\Hacienda;

use Spatie\LaravelData\Data;
use Spatie\LaravelData\Optional;
use Spatie\LaravelData\Attributes\MapInputName;

class DocStatusResponse extends Data
{
    public function __construct(
        #[MapInputName('clave')]
        public string $key,

        #[MapInputName('fecha')]
        public string $date,

        #[MapInputName('ind-estado')]
        public string $status,

        #[MapInputName('respuesta-xml')]
        public ?string $response_xml
    ) {}

    public function isAccepted(): bool 
    {
        return $this->status === 'aceptado';
    }

    public static function fromDatabase(object $record): self
    {
        return new self(
            $record->clave,
            $record->fecha_emision,
            $record->respuesta_hacienda ?? 'desconocido',
            $record->xml_respuesta
        );
    }
}
